$Title: (1) Split co2 and energy to rainfed and irrigated

*      ----------------------------------------------------------------      *
*                                                                            *
*                  Global Trade Analysis Project                             *
*                      GTAP Water database                                   *
*         (1)  SPLIT CO2  AND ENERGY TO RAINFED AND IRRIGATED                *
*                                                                            *
*      ----------------------------------------------------------------      *
SETS
FUEL_COMM
ERG_COMM
OLD_COMM
NEWCOM
NEWERG

PARAMETERS
MIG, MIP, MDG, MDP
EIG, EIP, EDG, EDP,  sNATd, EXI, GWH

MDF(FUEL_COMM,GLOB,REG)  "emissions from domestic product in current production, Mt CO2 [[MDF:FUEL_COMM*PROD_COMM*REG]]"
MIF(FUEL_COMM,GLOB,REG)  "emissions from imports in current production, Mt CO2          [[MIF:FUEL_COMM*PROD_COMM*REG]]"
EDF( ERG_COMM,GLOB,REG)  "usage of domestic product by firms, Mtoe                      [[EDF: ERG_COMM*PROD_COMM*REG]]"
EIF( ERG_COMM,GLOB,REG)  "usage of imports by firms, Mtoe                               [[EIF: ERG_COMM*PROD_COMM*REG]]"
;

$Gdxin ../%AggrName%in/CO2.gdx
$load FUEL_COMM, OLD_COMM=PROD_COMM
$load MDF, MDG, MDP, MIF, MIG, MIP
$Gdxin

$Gdxin ../%AggrName%in/GSDVOLE.gdx
$load ERG_COMM, NEWCOM, NEWERG
$load EDF, EDG, EDP, EIF, EIG, EIP, sNATd, EXI, GWH
$Gdxin

PARAMETER SHR_VA;

SHR_VA(C,'IRR',REG) =
 SUM((ENDW_COMM0,IC), VFM(ENDW_COMM0,IC,REG)$MAP_CROP(IC,C))/
(SUM((ENDW_COMM0,RC), VFM(ENDW_COMM0,RC,REG)$MAP_CROP(RC,C)) +
 SUM((ENDW_COMM0,IC), VFM(ENDW_COMM0,IC,REG)$MAP_CROP(IC,C)));

SHR_VA(C,'RFD',REG) =
 SUM((ENDW_COMM0,RC), VFM(ENDW_COMM0,RC,REG)$MAP_CROP(RC,C))/
(SUM((ENDW_COMM0,RC), VFM(ENDW_COMM0,RC,REG)$MAP_CROP(RC,C)) +
 SUM((ENDW_COMM0,IC), VFM(ENDW_COMM0,IC,REG)$MAP_CROP(IC,C)));

MDF(FUEL_COMM,GLOB,REG) = MDF(FUEL_COMM,GLOB,REG) ;
MIF(FUEL_COMM,GLOB,REG) = MIF(FUEL_COMM,GLOB,REG) ;
EDF( ERG_COMM,GLOB,REG) = EDF( ERG_COMM,GLOB,REG) ;
EIF( ERG_COMM,GLOB,REG) = EIF( ERG_COMM,GLOB,REG) ;

MDF(FUEL_COMM,IC,REG) = SUM(C, MDF(FUEL_COMM,C,REG)*SHR_VA(C,'IRR',REG)$MAP_CROP(IC,C));
MIF(FUEL_COMM,IC,REG) = SUM(C, MIF(FUEL_COMM,C,REG)*SHR_VA(C,'IRR',REG)$MAP_CROP(IC,C));
EDF( ERG_COMM,IC,REG) = SUM(C, EDF( ERG_COMM,C,REG)*SHR_VA(C,'IRR',REG)$MAP_CROP(IC,C));
EIF( ERG_COMM,IC,REG) = SUM(C, EIF( ERG_COMM,C,REG)*SHR_VA(C,'IRR',REG)$MAP_CROP(IC,C));

MDF(FUEL_COMM,RC,REG) = SUM(C, MDF(FUEL_COMM,C,REG)*SHR_VA(C,'RFD',REG)$MAP_CROP(RC,C));
MIF(FUEL_COMM,RC,REG) = SUM(C, MIF(FUEL_COMM,C,REG)*SHR_VA(C,'RFD',REG)$MAP_CROP(RC,C));
EDF( ERG_COMM,RC,REG) = SUM(C, EDF( ERG_COMM,C,REG)*SHR_VA(C,'RFD',REG)$MAP_CROP(RC,C));
EIF( ERG_COMM,RC,REG) = SUM(C, EIF( ERG_COMM,C,REG)*SHR_VA(C,'RFD',REG)$MAP_CROP(RC,C));

MDF(FUEL_COMM,GLOB,REG)$(NOT MDF(FUEL_COMM,GLOB,REG))  = EPS;
MIF(FUEL_COMM,GLOB,REG)$(NOT MIF(FUEL_COMM,GLOB,REG))  = EPS;
EDF( ERG_COMM,GLOB,REG)$(NOT EDF( ERG_COMM,GLOB,REG))  = EPS;
EIF( ERG_COMM,GLOB,REG)$(NOT EIF( ERG_COMM,GLOB,REG))  = EPS;

MDF(FUEL_COMM,C,REG) = 0;
MIF(FUEL_COMM,C,REG) = 0;
EDF( ERG_COMM,C,REG) = 0;
EIF( ERG_COMM,C,REG) = 0;
